fn PxIsClothMod modCloth =
(
	(classOf modCloth) == mCloth
)

fn PxCreateAsCloth =
(
	currentNode = PxGetCurrentNode()
	if currentNode != undefined then
	(
		if PxSeletionCanCreateCloth() then 
		(
			PxClothNodes (PxGetSelectedNodes())
			if (PxGetSelectionCount()) == 1 then (max modify mode)
			px_selectionChanged()  -- Update PhysX Tools dialog
		)
		else
		(
			Messagebox nvpxText.TXT_MODIFIERCLOTH_NOT_ALLOWED
		)
	)	
)

fn PxRemoveCloth =
(
	selNodes = PxGetSelectedNodes()
	
	for currentNode in selNodes do
	( 
		PxRemoveClothMod currentNode
	)
)

-- If adding a MassFX Cloth modifier, prepare to remove the previous one so there is only one on the stack
fn PxClothModifierPreAdded =
(

	t = callbacks.notificationParam()
	node = t[1]
	modCloth  = t[2]
	
	if (node != undefined) then
	(
		if PxIsClothMod(modCloth) then 
		(
			PxStopSimulation()
			-- cancel this addition
			existingClothMod = PxGetModCloth node
				
			if (existingClothMod != undefined) then
				PxAddModifierToTrash node modCloth
		)	
	)
)

-- Delete a modifer that was prepared to be deleted, and setup the physical mesh
fn PxClothModifierPostAdded =
(
	t = callbacks.notificationParam()
	node = t[1]
	
	if node != undefined then
	(
		modCloth  = t[2]
		
		-- If we added a MassFX Cloth...
		if PxIsClothMod(modCloth) then 
		(
			-- Remove new modifier on this node
			PxEmptyModifierTrash node modCloth
		)
	)	
)

-- If the modifier is being deleted, stop the simulation
fn PxClothModifierPreDelete =
(
	t = callbacks.notificationParam()
	node = t[1]
	mod  = t[2]
	
	if PxIsClothMod(mod) then
	(
		PxStopSimulation()
	)
)

-- Intialize the callbacks
callbacks.removeScripts id:#MassFXClothModifier
callbacks.addScript #preModifierAdded    "PxClothModifierPreAdded()"       id:#MassFXClothModifier
callbacks.addScript #postModifierAdded   "PxClothModifierPostAdded()"      id:#MassFXClothModifier
callbacks.addScript #preModifierDeleted  "PxClothModifierPreDelete()"      id:#MassFXClothModifier

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCKNASQ586vp/rULge/HlV3u8m6D84FoebO
-- Y9g7XCCvUAfS8orNu1ot+sEjJhAdHFNmvmpGnRVQPDe216Que5hwsUHLYZ9Qjrkt
-- brawKaXFwSlo+XiqKBBbikQqtd1FWzxRyjkAx2j4kmEiodRz/tzFpg7WS7V6ztS0
-- s8Gec7r1RsfWfJtSbQkFDdsQW2sZov/KKT6p9MTleK0BLC+WQn9vLkLRC50NoNOq
-- kU7fjUSROe30ZYsvQtfQVo8lFxETozHM0VMwtKpdtZTIYxhgoJydhwBARIlcyuC2
-- x/vvbZqP9b5TYx5WDXKisu2UD0IUMQvtrFmFCtBHikJ77qZm7UMv
-- -----END-SIGNATURE-----